CREATE PROCEDURE usp_Insert_Neurobehavioral_Symptom_Inventory
AS
BEGIN


BEGIN
INSERT INTO [V5_Registry].[dbo].[STD_SURVEY_TYPE]
           ([CODE],[NAME],[DESCRIPTION_TEXT],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES
           ('NSI', 'Neurobehavioral Symptom Inventory form', 'Neurobehavioral Symptom Inventory form', 'Initial', 'Initial', GETDATE(), GETDATE())
END

BEGIN
declare @type     int;


SELECT @type=  (SELECT ID [STD_SURVEY_TYPE_ID]
FROM STD_SURVEY_TYPE
WHERE CODE = 'NSI')

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION]
([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '1', 'Feeling Dizzy', 1, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '2', 'Loss of balance', 2, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '3', 'Poor coordination, clumsy', 3, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '4', 'Headaches', 4, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '5', 'Nausea', 5, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '6', 'Vision problems, blurring, trouble seeing', 6, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '7', 'Sensitivity to light', 7, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '8', 'Hearing diffuculty', 8, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '9', 'Sensitivity to noise', 9, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '10', 'Numbness or tingling on parts of my body', 10, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '11', 'Change in taste and/or smell', 11, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '12', 'Loss of appetite or increased appetite', 12, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '13', 'Poor concentration, cant pay attention, easily distracted', 13, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '14', 'Forgetfulness, cant remember things', 14, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '15', 'Difficulty making decisions', 15, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '16', 'Slowed thinking, difficulty getting organized, cant finish things', 16, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '17', 'Fatigue, loss of energy, getting tired easily', 17, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '18', 'Difficulty falling or staying asleep', 18, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '19', 'Feeling anxious or tense', 19, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '20', 'Feeling depressed or sad', 20, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '21', 'Irritability, easily annoyed', 21, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '22', 'Poor frustration tolerance, feeling easily overwhelmed by things', 22, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, 'D', 'Date:', 23, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)
           
           
END
 
BEGIN

declare @question     int, 
        @maxchoice    int,
        @choice       int,
        @sort         int;
        
SET @sort = 1                
--------Questions 1  Thru 22

QUEST1:
 
SELECT @question=  (SELECT q.ID  
FROM STD_QUESTION q
    ,STD_SURVEY_TYPE t
WHERE CODE = 'NSI' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = @sort)
----1
SET @choice = ((SELECT MAX(STD_QUESTION_CHOICE_ID) from [V5_Registry].[dbo].[STD_QUESTION_CHOICE]) + 1)

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '0' ,'0 = None  Rarely if ever present; not a problem at all',
            1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
---2
SET @choice = @choice + 1 

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '1',
            '1 = Mild  Occasionally present, but it does not disrupt my activities; I can usually continue what Im doing; doesnt really
concern me.', 2, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
---3
SET @choice = @choice + 1 

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '2',
            '2 = Moderate  Often present, occasionally disrupts my activities; I can usually continue what Im doing with some effort; I feel
somewhat concerned.', 3, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
---4
SET @choice = @choice + 1 

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '3',
            '3 = Severe  Frequently present and disrupts activities; I can only do things that are fairly simple or take little effort; I feel I need
help.', 4, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
---5
SET @choice = @choice + 1 

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '4',
            '4 = Very Severe  Almost always present and I have been unable to perform at work, school or home due to this problem; I
probably cannot function without help.', 5, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

SET @sort = @sort + 1

BEGIN 
IF @sort < 23
        GOTO QUEST1
END        
           
--------Question D

SELECT @question=  (SELECT q.ID  
FROM STD_QUESTION q
    ,STD_SURVEY_TYPE t
WHERE CODE = 'NSI' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 23)
----1
SET @choice = ((SELECT MAX(STD_QUESTION_CHOICE_ID) from [V5_Registry].[dbo].[STD_QUESTION_CHOICE]) + 1)

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, 'Date', 'Date', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

/*
SELECT * FROM [V5_Registry].[dbo].STD_SURVEY_TYPE
SELECT * FROM [V5_Registry].[dbo].STD_QUESTION
SELECT * FROM [V5_Registry].[dbo].STD_QUESTION_CHOICE 
*/
END

END